import javax.swing.*;
import java.awt.event.*;

public class Aplikacja extends JFrame {
  private JPopupMenu popupMenu;
  private JMenu subMenu;
  private JMenuItem miPozycja1, miPozycja2, miPozycja3, miPozycja4, miZamknij;
  private ActionListener al = new ActionListener(){
    public void actionPerformed(ActionEvent e) {
      if(e.getSource() == miZamknij)
        dispose();
    }
  };

  private MouseAdapter ma = new MouseAdapter(){
    public void mousePressed(MouseEvent e) {
      if(e.isPopupTrigger())
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }
    public void mouseReleased(MouseEvent e) {
      if(e.isPopupTrigger())
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }
  };

  public Aplikacja() {
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    popupMenu = new JPopupMenu();
    subMenu = new JMenu("Nastpne");
    miPozycja1 = new JMenuItem("Pozycja 1");
    miPozycja2 = new JMenuItem("Pozycja 2");
    miPozycja3 = new JMenuItem("Pozycja 3");
    miPozycja4 = new JMenuItem("Pozycja 4");
    miZamknij = new JMenuItem("Zamknij");

    miPozycja1.addActionListener(al);
    miPozycja2.addActionListener(al);
    miZamknij.addActionListener(al);

    subMenu.add(miPozycja3);
    subMenu.add(miPozycja4);
    subMenu.addSeparator();
    subMenu.add(miZamknij);

    popupMenu.add(miPozycja1);
    popupMenu.add(miPozycja2);
    popupMenu.add(subMenu);

    addMouseListener(ma);

    setSize(320, 200);
    setVisible(true);
  }
  public static void main(String args[]) {
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        new Aplikacja();
      }
    });
  }
}
